/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs;

import com.flemmli97.improvedmobs.capability.ITileOpened;
import com.flemmli97.improvedmobs.capability.PlayerDifficultyData;
import com.flemmli97.improvedmobs.capability.TileCap;
import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.config.ConfigSpecs;
import com.flemmli97.improvedmobs.config.EquipmentList;
import com.flemmli97.improvedmobs.events.DifficultyHandler;
import com.flemmli97.improvedmobs.events.EventHandler;
import com.flemmli97.improvedmobs.network.PacketHandler;
import com.flemmli97.improvedmobs.utils.ItemAITasks;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="improvedmobs")
public class ImprovedMobs {
    public static final String MODID = "improvedmobs";
    public static final Logger logger = LogManager.getLogger((String)"improvedmobs");
    public static final String thrownEntityID = "improvedmobs:thrown_entity";
    public static final String waterRiding = "improvedmobs:water_riding";
    public static final String disableShield = "improvedmobs:trigger_shield";

    public ImprovedMobs() {
        File file = FMLPaths.CONFIGDIR.get().resolve(MODID).toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigSpecs.clientSpec, "improvedmobs/client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigSpecs.commonSpec, "improvedmobs/common.toml");
    }

    @SubscribeEvent
    static void setup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        ItemAITasks.initAI();
        try {
            EquipmentList.initEquip();
        }
        catch (EquipmentList.InvalidItemNameException e) {
            logger.error(e.getMessage());
        }
        CapabilityManager.INSTANCE.register(ITileOpened.class, (Capability.IStorage)new Capability.IStorage<ITileOpened>(){

            @Nullable
            public INBT writeNBT(Capability<ITileOpened> capability, ITileOpened instance, Direction side) {
                CompoundNBT compound = new CompoundNBT();
                instance.writeToNBT(compound);
                return compound;
            }

            public void readNBT(Capability<ITileOpened> capability, ITileOpened instance, Direction side, INBT nbt) {
                instance.readFromNBT((CompoundNBT)nbt);
            }
        }, TileCap::new);
        CapabilityManager.INSTANCE.register(PlayerDifficultyData.class, (Capability.IStorage)new Capability.IStorage<PlayerDifficultyData>(){

            @Nullable
            public INBT writeNBT(Capability<PlayerDifficultyData> capability, PlayerDifficultyData instance, Direction side) {
                CompoundNBT compound = new CompoundNBT();
                instance.save(compound);
                return compound;
            }

            public void readNBT(Capability<PlayerDifficultyData> capability, PlayerDifficultyData instance, Direction side, INBT nbt) {
                instance.load((CompoundNBT)nbt);
            }
        }, PlayerDifficultyData::new);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        if (Config.CommonConfig.enableDifficultyScaling) {
            MinecraftForge.EVENT_BUS.register((Object)new DifficultyHandler());
        }
    }

    @SubscribeEvent
    static void conf(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == ConfigSpecs.clientSpec) {
            Config.ClientConfig.load();
        } else if (event.getConfig().getSpec() == ConfigSpecs.commonSpec) {
            Config.CommonConfig.load();
        }
    }
}

